#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <netdb.h>
#include <sys/socket.h>
#include <arpa/inet.h>

#define PORT 1234
#define MESSAGE "Hello, world!\n"

void error (char *msg)
{
  fprintf (stderr, "%s\n", msg);
  exit (1);
}

int main (void)
{
  int s;
  struct sockaddr_in name;
  if ((s = socket (PF_INET, SOCK_STREAM, 0)) < 0)
    error ("cannot create socket");
  memset (&name, 0, sizeof (name));
  name.sin_family = AF_INET;
  name.sin_port = htons (PORT);
  name.sin_addr.s_addr = htonl (INADDR_ANY);
  int on = 1;
  setsockopt (s, SOL_SOCKET, SO_REUSEADDR, (void *) &on, sizeof (on));
  if (bind (s, (struct sockaddr *) &name, sizeof (name)) < 0)
    {
      close (s);
      error ("cannot bind socket");
    }
  if (listen (s, 16) < 0)
    {
      close (s);
      error ("cannot listen on socket");
    }
  struct sockaddr_in clientname;
  size_t size = sizeof (clientname);
  s = accept (s, (struct sockaddr *) &clientname, &size);
  if (s < 0)
    error ("cannot accept connection");
  char *host_address = inet_ntoa (clientname.sin_addr);
  char *host_name;
  struct hostent *hp = gethostbyaddr ((void *) &clientname.sin_addr, sizeof (clientname.sin_addr), clientname.sin_family);
  if (hp)
    host_name = hp->h_name;
  else
    host_name = inet_ntoa (clientname.sin_addr);
  int remote_port = ntohs (clientname.sin_port);
  printf ("connection from %s [%s], port %d\n",
          host_name, host_address, remote_port);
  send (s, MESSAGE, strlen (MESSAGE), 0);
  shutdown (s, SHUT_RDWR);
  close (s);
  return 0;
}
