#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <netdb.h>
#include <sys/socket.h>
#include <arpa/inet.h>

#define TARGET_HOST "localhost"
#define PORT 1234
#define MESSAGE "Hello, world!\n"

void error (char *msg)
{
  fprintf (stderr, "%s\n", msg);
  exit (1);
}

int main (void)
{
  int s;
  struct sockaddr_in name;
  if ((s = socket (PF_INET, SOCK_STREAM, 0)) < 0)
    error ("cannot create socket");
  memset (&name, 0, sizeof (name));
  name.sin_family = AF_INET;
  name.sin_port = htons (PORT);
  name.sin_addr.s_addr = htonl (INADDR_ANY);
  struct hostent *ho = gethostbyname (TARGET_HOST);
  if (!ho)
    {
      close (s);
      error ("name server lookup error");
    }
  if (ho->h_length > (int) sizeof (name.sin_addr))
    ho->h_length = sizeof (name.sin_addr);
  memcpy (&name.sin_addr, ho->h_addr, ho->h_length);
  if (connect (s, (struct sockaddr *) &name, sizeof (name)) < 0)
    {
      close (s);
      error ("cannot connect to socket");
    }
  send (s, MESSAGE, strlen (MESSAGE), 0);
  shutdown (s, SHUT_RDWR);
  close (s);
  return 0;
}
