#include <stdio.h>
#include "textgraph.h"

char buffer[HEIGHT][WIDTH];

void clear_buffer (void)
{
  int x, y;
  for (y = 0; y < HEIGHT; y++)
    for (x = 0; x < WIDTH; x++)
      buffer[y][x] = ' ';
}

void dump_buffer (void)
{
  int x, y;
  for (y = HEIGHT - 1; y >= 0; y--)
    {
      for (x = 0; x < WIDTH; x++)
        printf ("%c", buffer[y][x]);
      printf ("\n");
    }
}

void set_point (int x, int y, char value)
{
  buffer[y][x] = value;
}

char get_point (int x, int y)
{
  return buffer[y][x];
}

void recursive_flood_fill (int x, int y, char old_value, char new_value)
{
  if (get_point (x, y) == old_value)
    {
      set_point (x, y, new_value);
      recursive_flood_fill (x + 1, y, old_value, new_value);
      recursive_flood_fill (x - 1, y, old_value, new_value);
      recursive_flood_fill (x, y + 1, old_value, new_value);
      recursive_flood_fill (x, y - 1, old_value, new_value);
    }
}

void flood_fill (int x, int y, char value)
{
  int old_value = get_point (x, y);
  recursive_flood_fill (x, y, old_value, value);
}
