#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/freeglut.h>
#include "opengl-magic.h"

float t = 0.0;

void draw (void)
{
  glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  set_material_color (1.0, 0.7, 0.0);
  glPushMatrix ();
  glRotatef (27.32 * t, 0.5, 1.0, 0.0);
  int level_counter = t * 0.5;
  static GLdouble sponge_offsets[3] = { 0.0, 0.0, 0.0 };
  glutSolidSierpinskiSponge (level_counter % 7, sponge_offsets, 0.5);
  glPopMatrix ();
  glFlush ();
  glutSwapBuffers ();
}

void timer_handler (int value)
{
  t += 0.05;
  glutPostRedisplay ();
  glutTimerFunc (50, timer_handler, 0);
}

int main (int argc, char **argv)
{
  init_opengl (&argc, argv, "Cube");
  glutDisplayFunc (draw);
  glutTimerFunc (50, timer_handler, 0);
  glutMainLoop ();
  return 0;
}
