#include <stdio.h>
#include <string.h>
#include <unistd.h>

int comp_counter = 0;

void clear_screen (void)
{
  printf ("\e[H\e[J");
}

void output_marked (char **name, int mark1, int mark2)
{
  clear_screen ();
  for (int i = 0; name[i]; i++)
    if (i == mark1 || i == mark2)
      printf ("%s <--\n", name[i]);
    else
      printf ("%s\n", name[i]);
  printf ("%d\n", comp_counter);
}

void output (char **name)
{
  output_marked (name, -1, -1);
}

int compare (char **name, int left, int right)
{
  comp_counter++;
  output_marked (name, left, right);
  usleep (200000);
  return strcmp (name[left], name[right]);
}

void sort (char **name, int size)
{
  int swapped = 1;
  int n = size;
  while (swapped)
    {
      swapped = 0;
      for (int i = 0; i < n - 1; i++)
        if (compare (name, i, i + 1) > 0)
          {
            char *temp = name[i];
            name[i] = name[i + 1];
            name[i + 1] = temp;
            swapped = 1;
          }
      n--;
    }
}

int main (void)
{
  char *names[] = { "Otto", "Lisa", "Anna", "Heinrich", "Siegfried", "Peter",
                    "Dieter", "Hugo", "Berta", "Maria", "Fritz", "Box", "Hans",
                    "Thomas", "Ulrich", "Zacharias", NULL };
  sort (names, 16);
  output (names);
  return 0;
}
