#include <stdio.h>
#include <string.h>
#include <unistd.h>

int comp_counter = 0;

void clear_screen (void)
{
  printf ("\e[H\e[J");
}

void output_marked (char **name, int mark1, int mark2)
{
  clear_screen ();
  for (int i = 0; name[i]; i++)
    if (i == mark1 || i == mark2)
      printf ("%s <--\n", name[i]);
    else
      printf ("%s\n", name[i]);
  printf ("%d\n", comp_counter);
}

void output (char **name)
{
  output_marked (name, -1, -1);
}

int compare (char **name, int left, int right)
{
  comp_counter++;
  output_marked (name, left, right);
  usleep (200000);
  return strcmp (name[left], name[right]);
}

int find_first (char **name, int first_pos)
{
  if (name == NULL || name[first_pos] == NULL)
    return -1;
  char *first = name[first_pos];
  int i = first_pos + 1;
  while (name[i])
    {
      if (compare (name, i, first_pos) < 0)
        {
          first_pos = i;
          first = name[i];
        }
      i++;
    }
  return first_pos;
}

void sort (char **name)
{
  if (name)
    for (int i = 0; name[i] != NULL; i++)
      {
        int first = find_first (name, i);
        char *temp = name[i];
        name[i] = name[first];
        name[first] = temp;
      }
}

int main (void)
{
  char *names[] = { "Otto", "Lisa", "Anna", "Heinrich", "Siegfried", "Peter",
                    "Dieter", "Hugo", "Berta", "Maria", "Fritz", "Box", "Hans",
                    "Thomas", "Ulrich", "Zacharias", NULL };
  sort (names);
  output (names);
  return 0;
}
