#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <errno.h>
#include <string.h>

#define WIDTH 1024
#define HEIGHT 768

unsigned char *display_mem;

void clear (void)
{
  for (int i = 0; i < WIDTH * HEIGHT / 8; i++)
    display_mem[i] = 0;
}

void draw_pixel (int x, int y)
{
  if (x >= 0 && x < WIDTH && y >= 0 && y < HEIGHT)
    display_mem[(y * WIDTH + x) / 8] |= 0x80 >> x % 8;
}

void draw_line_internal (int x0, int y0, int x1, int y1, int swapped)
{
  double slope = ((double) (y1 - y0)) / ((double) (x1 - x0));
  for (int x = x0; x <= x1; x++)
    {
      int y = (x - x0) * slope + y0;
      if (swapped)
        draw_pixel (y, x);
      else
        draw_pixel (x, y);
    }
}

void draw_line (int x0, int y0, int x1, int y1)
{
  if (abs (y1 - y0) <= abs (x1 - x0))
    if (x1 > x0)
      draw_line_internal (x0, y0, x1, y1, 0);
    else
      draw_line_internal (x1, y1, x0, y0, 0);
  else
    if (y1 > y0)
      draw_line_internal (y0, x0, y1, x1, 1);
    else
      draw_line_internal (y1, x1, y0, x0, 1);
}

void draw_plant (float x, float y, float dx, float dy, int depth)
{
  if (depth > 0)
    {
      float x1 = x + dx;
      float y1 = y + dy;
      float dx1, dy1, alpha;
      draw_line (x, y, x1, y1);
      alpha = sin (-5.0 * M_PI / 180.0);
      dx1 = 0.9 * (dx * cos (alpha) - dy * sin (alpha));
      dy1 = 0.9 * (dx * sin (alpha) + dy * cos (alpha));
      draw_plant (x1, y1, dx1, dy1, depth - 1);
      alpha = sin (5.0 * M_PI / 180.0);
      dx1 = 0.35 * (dx * cos (alpha) - dy * sin (alpha));
      dy1 = 0.35 * (dx * sin (alpha) + dy * cos (alpha));
      draw_plant (x1, y1, dx1, dy1, depth - 1);
    }
}

void save_as (char *filename)
{
  FILE *outfile = fopen (filename, "wb");
  if (!outfile)
    {
      fprintf (stderr, "cannot open file %s for writing: %s\n",
               filename, strerror (errno));
      exit (1);
    }
  fprintf (outfile, "P4\n%d\n%d\n", WIDTH, HEIGHT);
  fwrite (display_mem, 1, WIDTH * HEIGHT / 8, outfile);
  fclose (outfile);
}

int main (int argc, char **argv)
{
  display_mem = malloc (WIDTH * HEIGHT / 8);
  clear ();
  draw_plant (400, 0, 0, 100, 13);
  save_as ("plant-4.pbm");
  return 0;
}
