#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/freeglut.h>
#include <math.h>
#include "opengl-magic.h"

#define g 9.81
#define l 1.0
#define dt 0.05
#define phi0 30.0  /* degrees */

float t = 0.0;
float phi = phi0 * M_PI / 180.0;
float v = 0.0;

void calc (void)
{
  float a = -g * phi;
  v += dt * a;
  phi += dt * v / l;
}

void draw (void)
{
  glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  set_material_color (0.8, 0.8, 1.0);
  glPushMatrix ();
  glRotatef (90, 1.0, 0.0, 0.0);
  glTranslatef (0.0, 0.0, -0.75);
  glRotatef (180.0 + phi0 * cos (sqrt (g / l) * t), 0.0, 1.0, 0.0);
  glTranslatef (0.0, 0.0, -1.0);
  glutSolidCylinder (0.01, 1.0, 13, 1);
  glutSolidSphere (0.1, 31, 10);
  glPopMatrix ();
  set_material_color (1.0, 0.8, 0.0);
  glPushMatrix ();
  glRotatef (90, 1.0, 0.0, 0.0);
  glTranslatef (0.0, 0.0, -0.75);
  glRotatef (180.0 + phi * 180.0 / M_PI, 0.0, 1.0, 0.0);
  glTranslatef (0.0, 0.0, -1.0);
  glutSolidCylinder (0.01, 1.0, 13, 1);
  glutSolidSphere (0.1, 31, 10);
  glPopMatrix ();
  glFlush ();
  glutSwapBuffers ();
}

void timer_handler (int value)
{
  calc ();
  t += dt;
  glutPostRedisplay ();
  glutTimerFunc (50, timer_handler, 0);
}

int main (int argc, char **argv)
{
  init_opengl (&argc, argv, "Pendulum");
  glutDisplayFunc (draw);
  glutTimerFunc (50, timer_handler, 0);
  glutMainLoop ();
  return 0;
}
