#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include "opengl-magic.h"

void init_opengl (int *argcp, char **argv, char *window_name)
{
  glutInit (argcp, argv);
  glutInitDisplayMode (GLUT_RGBA | GLUT_DOUBLE | GLUT_DEPTH);
  glutInitWindowSize (1024, 768);
  glutCreateWindow (window_name);
  glMatrixMode (GL_PROJECTION);
  glLoadIdentity ();
  gluPerspective (20.0, -1.33333, 3.0, 7.0);
  glMatrixMode (GL_MODELVIEW);
  glLoadIdentity ();
  glTranslatef (0.0, 0.0, -5.0);
  glClearColor (0.0, 0.0, 0.0, 0.0);
  glEnable (GL_DEPTH_TEST);
  glEnable (GL_LIGHTING);
  glEnable (GL_LIGHT0);
  static GLfloat light0_position[] = { 1.0, 0.0, 1.0, 0.0 };
  glLightfv (GL_LIGHT0, GL_POSITION, light0_position);
}

void set_material_color (float r, float g, float b)
{
  GLfloat color[] = { r, g, b };
  glMaterialfv (GL_FRONT, GL_AMBIENT, color);
  glMaterialfv (GL_FRONT, GL_DIFFUSE, color);
}
