#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include <stdio.h>
#include <stdlib.h>

#define WIDTH 1024
#define HEIGHT 768

unsigned char *display_mem;

void clear (void)
{
  for (int i = 0; i < WIDTH * HEIGHT / 8; i++)
    display_mem[i] = 0;
}

void draw_pixel (int x, int y)
{
  if (x >= 0 && x < WIDTH && y >= 0 && y < HEIGHT)
    display_mem[(y * WIDTH + x) / 8] |= 0x80 >> x % 8;
}

void draw_line_internal (int x0, int y0, int x1, int y1, int swapped)
{
  int p = abs (y1 - y0);

  int dy = y1 > y0 ? 1 : -1;   /* ternrer Operator */

  /* Bedeutung:

      if (y1 > y0)
        dy = 1;
      else
        dy = -1;
   */

  int q = x1 - x0;
  int r = q / 2;
  int y = y0;
  for (int x = x0; x <= x1; x++)
    {
      if (swapped)
        draw_pixel (y, x);
      else
        draw_pixel (x, y);
      r += p;
      if (r >= q)
        {
          y += dy;
          r -= q;
        }
    }
}

void draw_line (int x0, int y0, int x1, int y1)
{
  if (abs (y1 - y0) <= abs (x1 - x0))
    if (x1 > x0)
      draw_line_internal (x0, y0, x1, y1, 0);
    else
      draw_line_internal (x1, y1, x0, y0, 0);
  else
    if (y1 > y0)
      draw_line_internal (y0, x0, y1, x1, 1);
    else
      draw_line_internal (y1, x1, y0, x0, 1);
}

void draw (void)
{
  glClearColor (0.0, 0.0, 0.0, 0.0);
  glClear (GL_COLOR_BUFFER_BIT);
  clear ();
  draw_line (100, 200, 200, 600);
  draw_line (200, 600, 600, 500);
  draw_line (600, 500, 500, 100);
  draw_line (500, 100, 100, 200);
  glRasterPos3f (-1.0, -1.0, 0.0);
  glBitmap (WIDTH, HEIGHT, 0.0, 0.0, 0.0, 0.0, display_mem);
  glFlush ();
  glutSwapBuffers ();
}

int main (int argc, char **argv)
{
  display_mem = malloc (WIDTH * HEIGHT / 8);
  glutInit (&argc, argv);
  glutInitDisplayMode (GLUT_RGB | GLUT_DOUBLE);
  glutInitWindowSize (WIDTH, HEIGHT);
  (void) glutCreateWindow ("Test");
  glutDisplayFunc (draw);
  glutMainLoop ();
  return 0;
}
