#include <stdio.h>
#include <stdint.h>
#include <string.h>

uint8_t rc4_sbox[256];
uint8_t rc4_i, rc4_j;

void print_hex (char *text, int text_length)
{
  for (int i = 0; i < text_length; i++)
    printf ("%02x", (uint8_t) text[i]);
  printf ("\n");
}

void rc4_srand (char *key, int key_length)
{
  uint8_t *s = rc4_sbox;

  int i, j;
  for (i = 0; i < 256; i++)
    s[i] = i;
  j = 0;
  for (i = 0; i < 256; i++)
    {
      j = (j + s[i] + key[i % key_length]) % 256;
      uint8_t temp = s[i];
      s[i] = s[j];
      s[j] = temp;
    }

  rc4_i = rc4_j = 0;
}

uint8_t rc4_rand (void)
{
  uint8_t *s = rc4_sbox;
  uint8_t i = rc4_i;
  uint8_t j = rc4_j;
  uint8_t result;

  i = (i + 1) % 256;
  j = (j + s[i]) % 256;
  uint8_t temp = s[i];
  s[i] = s[j];
  s[j] = temp;
  result = s[(s[i] + s[j]) % 256];

  rc4_i = i;
  rc4_j = j;
  return result;
}

void crypt (char *key, int key_length, char *text, int text_length)
{
  rc4_srand (key, key_length);
  for (int i = 0; i < text_length; i++)
    text[i] ^= rc4_rand () % 256;
}

int main (void)
{
  char key[] = "geheim";
  int key_length = strlen (key);
  char text[] = "Apfelkuchen";
  int text_length = strlen (text);

  printf ("%s\n", text);
  crypt (key, key_length, text, text_length);
  print_hex (text, text_length);
  crypt (key, key_length, text, text_length);
  printf ("%s\n", text);

  return 0;
}
