char buffer[128];

void set_bit (int index)
{
  int byte_index = index / 8;
  int bit_index = index % 8;
  buffer[byte_index] |= 1 << bit_index;
}

void clear_bit (int index)
{
  int byte_index = index / 8;
  int bit_index = index % 8;
  buffer[byte_index] &= ~(1 << bit_index);
}

int get_bit (int index)
{
  int byte_index = index / 8;
  int bit_index = index % 8;
  if (buffer[byte_index] & (1 << bit_index))
    return 1;
  else
    return 0;
}
