#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <errno.h>
#include <string.h>
#include "textured-spheres.h"

#ifndef __USE_POSIX
  extern int fileno (FILE *stream);
#endif

void init_texture (char *image_filename, int image_width, GLuint *texture)
{
  FILE *f = fopen (image_filename, "r");
  if (!f)
    {
      fprintf (stderr, "textured-spheres.c: cannot open texture file \"%s\": %s",
               image_filename, strerror (errno));
      exit (1);
    }
  struct stat st;
  fstat (fileno (f), &st);
  size_t size = st.st_size;
  int image_height = size / (3 * image_width);
        char *image = malloc (size);
  if (!image)
    {
      fprintf (stderr, "textured-spheres.c: cannot load texture file \"%s\": out of memory",
               image_filename);
      exit (1);
    }
  fread (image, size, 1, f);
  fclose (f);
  glGenTextures (1, texture);
  glBindTexture (GL_TEXTURE_2D, *texture);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR_MIPMAP_LINEAR);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
  glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
  gluBuild2DMipmaps (GL_TEXTURE_2D, 3, image_width, image_height, GL_RGB, GL_UNSIGNED_BYTE, image);
}

void draw_textured_sphere (GLuint texture, GLdouble radius, GLint slices, GLint stacks)
{
  static GLfloat white_color[] = { 1.0, 1.0, 1.0 };
  glMaterialfv (GL_FRONT, GL_AMBIENT, white_color);
  glMaterialfv (GL_FRONT, GL_DIFFUSE, white_color);
  glBindTexture (GL_TEXTURE_2D, texture);
  glEnable (GL_TEXTURE_2D);
  GLUquadric *sphere = gluNewQuadric ();
  gluQuadricTexture (sphere, GL_TRUE);
  gluSphere (sphere, radius, slices, stacks);
  glDisable (GL_TEXTURE_2D);
}
