#include <stdio.h>
#include "robotext.h"

#define MAP_SIZE_X 30
#define MAP_SIZE_Y 30

#define MARK_UNKNOWN   ' '
#define MARK_KNOWN     'o'
#define MARK_WALL      '#'
#define MARK_REACHABLE '.'

char map[MAP_SIZE_Y][MAP_SIZE_X];
int rx = 15, ry = 15;
int dx = 1, dy = 0;

void init_map (void)
{
  for (int y = 0; y < MAP_SIZE_Y; y++)
    for (int x = 0; x < MAP_SIZE_X; x++)
      map[y][x] = MARK_UNKNOWN;
}

void show_map (void)
{
  for (int y = 0; y < MAP_SIZE_Y; y++)
    {
      for (int x = 0; x < MAP_SIZE_X; x++)
        if (x == rx && y == ry)
          printf (" %c", 'R');
        else
          printf (" %c", map[y][x]);
      printf ("\n");
    }
}

void mark_as_known (int x, int y)
{
  map[y][x] = MARK_KNOWN;
}

void mark_as_wall (int x, int y)
{
  map[y][x] = MARK_WALL;
}

void mark_as_reachable (int x, int y)
{
  if (map[y][x] == MARK_UNKNOWN)
    map[y][x] = MARK_REACHABLE;
}

void logical_move (int distance)
{
  rx += dx;
  ry += dy;
}

void logical_rotate (int degrees)
{
  if (degrees == 180 || degrees == -180)
    {
      dx = -dx;
      dy = -dy;
    }
  else if (degrees == 90 || degrees == -270)
    {
      int temp = dx;
      dx = dy;
      dy = -temp;
    }
  else if (degrees == -90 || degrees == 270)
    {
      int temp = dx;
      dx = -dy;
      dy = temp;
    }
  else if (degrees != 0)
    game_over ();
}

int main (void)
{
  setup ();
  rotate_to (EAST);
  init_map ();
  mark_as_known (rx, ry);
  mark_as_reachable (rx + 1, ry);
  mark_as_reachable (rx - 1, ry);
  mark_as_reachable (rx, ry + 1);
  mark_as_reachable (rx, ry - 1);
  show_map ();
  pause ();
  while (1)
    {
      move (1);
      logical_move (1);
      show_map ();
      pause ();
      if (found_wall ())
        {
          mark_as_wall (rx, ry);
          rotate (180);
          logical_rotate (180);
          move (1);
          logical_move (1);
          show_map ();
          pause ();
          rotate (90);
          logical_rotate (90);
        }
      else
        mark_as_known (rx, ry);
      mark_as_reachable (rx + 1, ry);
      mark_as_reachable (rx - 1, ry);
      mark_as_reachable (rx, ry + 1);
      mark_as_reachable (rx, ry - 1);
    }
  return 0;
}
