#include <stdio.h>
#include <stdlib.h>

#define SIZE_X 60
#define SIZE_Y 30

char world[SIZE_Y][SIZE_X + 1] = {
  "         ________________________________                   ",
  "      _-~                                ~-_                ",
  "    .~                                      ~.              ",
  "    |                                        |              ",
  "    |                                        |              ",
  "    |                                        |              ",
  "    |            .-----.                     |              ",
  "    |            |     |                     `--------.     ",
  "    |            |     |                              |     ",
  "    |            `-----'                              |     ",
  "    |                                                 |     ",
  "    |                                                 |     ",
  "    |                                                 |     ",
  "    |                              .------------------'     ",
  "    |                              |                        ",
  "    |                              `------------------.     ",
  "    |                                                 |     ",
  "    |                                                 |     ",
  "    |                                                 |     ",
  "    `------------____                                 |     ",
  "                     ~~-.                             |     ",
  "                         |                            |     ",
  "                         |                            |     ",
  "                         |                          R |     ",
  "                         |____________________________|     ",
  "                                                            ",
  "                                                            ",
  "                                                            ",
  "                                                            ",
  "                                                            " };

int rx = SIZE_X / 2, ry = SIZE_Y / 2;
int dx = 1, dy = 0;

void setup (void)
{
  for (int y = 0; y < SIZE_Y; y++)
    for (int x = 0; x < SIZE_X; x++)
      if (world[y][x] == 'R')
        {
          rx = x;
          ry = y;
          world[y][x] = ' ';
        }
}

void show_world (void)
{
  char Rsave = world[ry][rx];
  world[ry][rx] = 'R';
  for (int y = 0; y < SIZE_Y; y++)
    printf ("%s\n", world[y]);
  world[ry][rx] = Rsave;
}

void pause (void)
{
  char dummy[42];
  fgets (dummy, 42, stdin);
}

void check (void)
{
  if (rx < 0 || rx >= SIZE_X || ry < 0 || ry >= SIZE_Y)
    {
      printf ("GAME OVER\n");
      exit (1);
    }
}

void move (int distance)
{
  rx += 2 * distance * dx;
  ry += distance * dy;
  check ();
}

int main (void)
{
  setup ();
  show_world ();
  pause ();
  for (int i = 0; i < 10; i++)
    {
      move (1);
      show_world ();
      pause ();
    }
  return 0;
}
