#include <stdio.h>

#define SIZE_X 60
#define SIZE_Y 30

char world[SIZE_Y][SIZE_X + 1] = {
  "         ________________________________                   ",
  "      _-~                                ~-_                ",
  "    .~                                      ~.              ",
  "    |                                        |              ",
  "    |                                        |              ",
  "    |                                        |              ",
  "    |            .-----.                     |              ",
  "    |            |     |                     `--------.     ",
  "    |            |     |                              |     ",
  "    |            `-----'                              |     ",
  "    |                                                 |     ",
  "    |                                                 |     ",
  "    |                                                 |     ",
  "    |                              .------------------'     ",
  "    |                              |                        ",
  "    |                              `------------------.     ",
  "    |                                                 |     ",
  "    |                                                 |     ",
  "    |                                                 |     ",
  "    `------------____                                 |     ",
  "                     ~~-.                             |     ",
  "                         |                            |     ",
  "                         |                            |     ",
  "                         |                          R |     ",
  "                         |____________________________|     ",
  "                                                            ",
  "                                                            ",
  "                                                            ",
  "                                                            ",
  "                                                            " };

int rx = SIZE_X / 2, ry = SIZE_Y / 2;

void setup (void)
{
  for (int y = 0; y < SIZE_Y; y++)
    for (int x = 0; x < SIZE_X; x++)
      if (world[y][x] == 'R')
        {
          rx = x;
          ry = y;
          world[y][x] = ' ';
        }
}

void show_world (void)
{
  char Rsave = world[ry][rx];
  world[ry][rx] = 'R';
  for (int y = 0; y < SIZE_Y; y++)
    printf ("%s\n", world[y]);
  world[ry][rx] = Rsave;
}

int main (void)
{
  setup ();
  show_world ();
  return 0;
}
