#include <stdio.h>
#include <string.h>
#include <unistd.h>

int comp_counter = 0;

void clear_screen (void)
{
  printf ("\e[H\e[J");
}

void output_marked (char **name, int mark)
{
  clear_screen ();
  for (int i = 0; name[i]; i++)
    if (i == mark)
      printf ("%s <--\n", name[i]);
    else
      printf ("%s\n", name[i]);
  printf ("%d\n", comp_counter);
}

void output (char **name)
{
  output_marked (name, -1);
}

int compare (char **name, int left, char *right)
{
  comp_counter++;
  output_marked (name, left);
  usleep (100000);
  return strcmp (name[left], right);
}

void sort (char **name, int left, int right)
{
  if (left < right)
    {
      int middle = (left + right) / 2;
      char *test = name[middle];
      int l = left;
      int r = right;
      while (l <= r)
        {
          while (compare (name, l, test) < 0)
            l++;
          while (compare (name, r, test) > 0)
            r--;
          if (l <= r)
            {
              char *temp = name[l];
              name[l] = name[r];
              name[r] = temp;
              l++;
              r--;
            }
        }
      sort (name, left, r);
      sort (name, l, right);
    }
}

int main (void)
{
  char *names[] = { "Anna", "Berta", "Box", "Dieter", "Fritz", "Hans",
                    "Heinrich", "Hugo", "Lisa", "Maria", "Otto", "Peter",
                    "Siegfried", "Thomas", "Ulrich", "Zacharias", NULL };
  sort (names, 0, 15);
  output (names);
  return 0;
}
