#include <stdio.h>
#include <string.h>

void output (char **name)
{
  for (int i = 0; name[i]; i++)
    printf ("%s\n", name[i]);
}

int find_first (char **name, int first_pos)
{
  if (name == NULL || name[first_pos] == NULL)
    return -1;
  char *first = name[first_pos];
  int i = first_pos + 1;
  while (name[i])
    {
      if (strcmp (name[i], first) < 0)
        {
          first_pos = i;
          first = name[i];
        }
      i++;
    }
  return first_pos;
}

void sort (char **name)
{
  if (name)
    for (int i = 0; name[i] != NULL; i++)
      {
        int first = find_first (name, i);
        char *temp = name[i];
        name[i] = name[first];
        name[first] = temp;
      }
}

int main (void)
{
  char *names[] = { "Otto", "Lisa", "Anna", "Heinrich", "Siegfried", "Peter",
                    "Dieter", "Hugo", "Berta", "Maria", "Fritz", "Box", "Hans",
                    "Thomas", "Ulrich", "Zacharias", NULL };
  sort (names);
  output (names);
  return 0;
}
