#include <stdio.h>
#include "robotext.h"

static char world[SIZE_Y][SIZE_X + 1] = {
  "         ________________________________                   ",
  "      _-~                                ~-_                ",
  "    .~                                      ~.              ",
  "    |                                        |              ",
  "    |                                        |              ",
  "    |                                        |              ",
  "    |            .-----.                     |              ",
  "    |            |     |                     `--------.     ",
  "    |            |     |                              |     ",
  "    |            `-----'                              |     ",
  "    |                                                 |     ",
  "    |                                                 |     ",
  "    |                                                 |     ",
  "    |                              .------------------'     ",
  "    |                              |                        ",
  "    |                              `------------------.     ",
  "    |                                                 |     ",
  "    |                                                 |     ",
  "    |                                                 |     ",
  "    `------------____                                 |     ",
  "                     ~~-.                             |     ",
  "                         |                            |     ",
  "                         |                            |     ",
  "                         |                          R |     ",
  "                         |____________________________|     ",
  "                                                            ",
  "                                                            ",
  "                                                            ",
  "                                                            ",
  "                                                            " };

static int rx = SIZE_X / 2, ry = SIZE_Y / 2;
static int dx = 1, dy = 0;

void setup (void)
{
  for (int y = 0; y < SIZE_Y; y++)
    for (int x = 0; x < SIZE_X; x++)
      if (world[y][x] == 'R')
        {
          rx = x;
          ry = y;
          world[y][x] = ' ';
        }
}

void show_world (void)
{
  char Rsave = world[ry][rx];
  world[ry][rx] = 'R';
  for (int y = 0; y < SIZE_Y; y++)
    printf ("%s\n", world[y]);
  world[ry][rx] = Rsave;
}

void pause (void)
{
  char dummy[42];
  fgets (dummy, 42, stdin);
}

void game_over (void)
{
  printf ("GAME OVER\n");
  exit (1);
}

static void check (void)
{
  if (rx < 0 || rx >= SIZE_X || ry < 0 || ry >= SIZE_Y)
    game_over ();
}

void move (int distance)
{
  rx += 2 * distance * dx;
  ry += distance * dy;
  check ();
}

void rotate_to (int direction)
{
  if (direction == EAST)
    {
      dx = 1;
      dy = 0;
    }
  else if (direction == NORTH)
    {
      dx = 0;
      dy = -1;
    }
  else if (direction == WEST)
    {
      dx = -1;
      dy = 0;
    }
  else if (direction == SOUTH)
    {
      dx = 0;
      dy = 1;
    }
  else
    game_over ();
}

void rotate (int degrees)
{
  if (degrees == 180 || degrees == -180)
    {
      dx = -dx;
      dy = -dy;
    }
  else if (degrees == 90 || degrees == -270)
    {
      int temp = dx;
      dx = dy;
      dy = -temp;
    }
  else if (degrees == -90 || degrees == 270)
    {
      int temp = dx;
      dx = -dy;
      dy = temp;
    }
  else if (degrees != 0)
    game_over ();
}

int found_wall (void)
{
  return world[ry][rx] != ' ' || world[ry][rx + dx] != ' ';
}
