#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include "opengl-magic.h"
#include "textured-spheres.h"

float t = 0.0;
float dt = 0.05;
GLuint earth_texture, moon_texture;

void draw_earth (void)
{
  glPushMatrix ();
  glRotatef (90, 1.0, 0.0, 0.0);
  glRotatef (100.0 * t, 0.0, 0.0, 1.0);
  draw_textured_sphere (earth_texture, 0.25512, 63, 20);
  glPopMatrix ();
}

void draw_moon (void)
{
  glPushMatrix ();
  glRotatef (90, 1.0, 0.0, 0.0);
  glRotatef (-90, 0.0, 0.0, 1.0);
  draw_textured_sphere (moon_texture, 0.06952, 31, 10);
  glPopMatrix ();
}

void draw (void)
{
  glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  glPushMatrix ();
  glRotatef (23.44, 1.0, 0.0, -1.0);
  draw_earth ();
  glRotatef (5.145, 0.0, 1.0, 1.0);
  glRotatef (30.0 * t, 0.0, -1.0, 0.0);
  glTranslatef (0.9, 0.0, 0.0);
  draw_moon ();
  glPopMatrix ();
  glFlush ();
  glutSwapBuffers ();
}

void timer_handler (int value)
{
  t += dt;
  glutPostRedisplay ();
  glutTimerFunc (50, timer_handler, 0);
}

void key_handler (unsigned char key, int x, int y)
{
  if (key == ' ')
    dt = -dt;        /* Leertaste --> Zeit andersherum */
  else if (key == '+')
    dt *= 1.5;
  else if (key == '-')
    dt /= 1.5;
}

int main (int argc, char **argv)
{
  init_opengl (&argc, argv, "Orbit");
  init_texture ("earth-texture.rgb", 1024, &earth_texture);
  init_texture ("moon-texture.rgb", 1080, &moon_texture);
  glutDisplayFunc (draw);
  glutTimerFunc (50, timer_handler, 0);
  glutKeyboardFunc (key_handler);
  glutMainLoop ();
  return 0;
}
