#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include "opengl-magic.h"

#define dt 0.05

float t = 0.0;
float x = -0.9;
float v = 0.1;

void draw (void)
{
  glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  glPushMatrix ();
  glTranslatef (x, 0, 0);
  glutSolidTeapot (0.05);
  glPopMatrix ();
  glFlush ();
  glutSwapBuffers ();
}

void timer_handler (int value)
{
  t += dt;
  x += v * dt;
  glutPostRedisplay ();
  glutTimerFunc (50, timer_handler, 0);
}

int main (int argc, char **argv)
{
  init_opengl (&argc, argv, "Orbit");
  glutDisplayFunc (draw);
  glutTimerFunc (50, timer_handler, 0);
  glutMainLoop ();
  return 0;
}
