#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include "opengl-magic.h"

float t = 0.0;

void draw (void)
{
  glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  glPushMatrix ();
  glRotatef (23.44, 1.0, 0.0, -1.0);
  set_material_color (0.7, 0.7, 1.0);
  glutSolidTeapot (0.25512);
  glRotatef (30.0 * t, 0.0, -1.0, 0.0);
  glTranslatef (0.9, 0.0, 0.0);
  set_material_color (1.0, 0.7, 0.0);
  glutSolidTorus (0.01, 0.1, 15, 31);
  glPopMatrix ();
  glFlush ();
  glutSwapBuffers ();
}

void timer_handler (int value)
{
  t += 0.05;
  glutPostRedisplay ();
  glutTimerFunc (50, timer_handler, 0);
}

int main (int argc, char **argv)
{
  init_opengl (&argc, argv, "Orbit");
  glutDisplayFunc (draw);
  glutTimerFunc (50, timer_handler, 0);
  glutMainLoop ();
  return 0;
}
