#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include <stdlib.h>

#define WIDTH 1024
#define HEIGHT 768

#define STEP 64

unsigned char *display_mem;

void clear_display (void)
{
  for (int i = 0; i < WIDTH * HEIGHT / 8; i++)
    display_mem[i] = 0;
}

void draw_point (int x, int y)
{
  int i = y * WIDTH / 8;
  i += x / 8;
  display_mem[i] |= 1 << (7 - x % 8);
}

void draw_vertical_line (int x, int y0, int y1)
{
  for (int y = y0; y <= y1; y++)
    draw_point (x, y);
}

void draw_horizontal_line (int x0, int x1, int y)
{
  for (int x = x0; x <= x1; x++)
    draw_point (x, y);
}

void draw (void)
{
  glClearColor (0.0, 0.0, 0.0, 0.0);
  glClear (GL_COLOR_BUFFER_BIT);
  clear_display ();
  for (int x = STEP; x <= WIDTH - STEP; x += STEP)
    draw_vertical_line (x, STEP, HEIGHT - STEP);
  for (int y = STEP; y <= HEIGHT - STEP; y += STEP)
    draw_horizontal_line (STEP, WIDTH - STEP, y);
  glBitmap (WIDTH, HEIGHT, 0.0, 0.0, 0.0, 0.0, display_mem);
  glFlush ();
  glutSwapBuffers ();
}

int main (int argc, char **argv)
{
  display_mem = malloc (WIDTH * HEIGHT / 8);
  glutInit (&argc, argv);
  glutInitDisplayMode (GLUT_RGB | GLUT_DOUBLE);
  glutInitWindowSize (WIDTH, HEIGHT);
  (void) glutCreateWindow ("Test");
  glutDisplayFunc (draw);
  glutMainLoop ();
  return 0;
}
