#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include <stdlib.h>

#define WIDTH 1024
#define HEIGHT 768

unsigned char *display_mem;

void draw (void)
{
  glClearColor (0.0, 0.0, 0.0, 0.0);
  glClear (GL_COLOR_BUFFER_BIT);
  for (int i = 0; i < WIDTH * HEIGHT / 8; i++)
    display_mem[i] = 0;
  /* Mitte = Zeile HEIGHT / 2, Spalte WIDTH / 2 */
  display_mem[(HEIGHT / 2) * WIDTH / 8 + 17] = 0b11111101;
  glBitmap (WIDTH, HEIGHT, 0.0, 0.0, 0.0, 0.0, display_mem);
  glFlush ();
  glutSwapBuffers ();
}

int main (int argc, char **argv)
{
  display_mem = malloc (WIDTH * HEIGHT / 8);
  glutInit (&argc, argv);
  glutInitDisplayMode (GLUT_RGB | GLUT_DOUBLE);
  glutInitWindowSize (WIDTH, HEIGHT);
  (void) glutCreateWindow ("Test");
  glutDisplayFunc (draw);
  glutMainLoop ();
  return 0;
}
