#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>

#define WIDTH 1024
#define HEIGHT 768

#define RED   0xff0000
#define GREEN 0x00ff00
#define BLUE  0x0000ff
#define RED_SHIFT   16
#define GREEN_SHIFT  8
#define BLUE_SHIFT   0
#define BLACK   0
#define YELLOW  (RED | GREEN)
#define CYAN    (GREEN | BLUE)
#define MAGENTA (RED | BLUE)
#define WHITE   (RED | GREEN | BLUE)

unsigned char *display_mem;
GLuint texture;

#define STACK_SIZE 100000

typedef struct
{
  int x, y;
}
pair;

pair the_stack[STACK_SIZE];

int stack_pointer = 0;

int stack_is_empty (void)
{
  return stack_pointer == 0;
}

void push_pair (int x, int y)
{
  if (stack_pointer < STACK_SIZE)
    {
      the_stack[stack_pointer].x = x;
      the_stack[stack_pointer].y = y;
      stack_pointer++;
    }
  else
    {
      fprintf (stderr, "push_pair: stack overflow\n");
      exit (1);
    }
}

void pop_pair (int *x, int *y)
{
  if (!stack_is_empty ())
    {
      stack_pointer--;
      *x = the_stack[stack_pointer].x;
      *y = the_stack[stack_pointer].y;
    }
  else
    {
      fprintf (stderr, "pop_pair: stack is empty\n");
      exit (1);
    }
}

void clear_display (void)
{
  for (int i = 0; i < WIDTH * HEIGHT * 4; i++)
    display_mem[i] = 0;
}

void draw_point (int x, int y, uint32_t colour)
{
  int i = y * WIDTH * 4;
  i += x * 4;
  display_mem[i + 0] = (colour & RED) >> RED_SHIFT;
  display_mem[i + 1] = (colour & GREEN) >> GREEN_SHIFT;
  display_mem[i + 2] = (colour & BLUE) >> BLUE_SHIFT;
}

uint32_t read_point (int x, int y)
{
  int i = y * WIDTH * 4;
  i += x * 4;
  return display_mem[i] << RED_SHIFT
         | display_mem[i + 1] << GREEN_SHIFT
         | display_mem[i + 2] << BLUE_SHIFT;
}

void fill (uint32_t old_colour, uint32_t new_colour)
{
  if (!stack_is_empty ())
    {
      int x, y;
      pop_pair (&x, &y);
      if (read_point (x, y) == old_colour)
        {
          draw_point (x, y, new_colour);
          push_pair (x + 1, y);
          push_pair (x - 1, y);
          push_pair (x, y + 1);
          push_pair (x, y - 1);
        }
    }
}

void draw_line (int x0, int y0, int x1, int y1, uint32_t colour)
{
  int p = y1 - y0;
  int q = x1 - x0;
  int r = q / 2;
  int y = y0;
  for (int x = x0; x <= x1; x++)
    {
      draw_point (x, y, colour);
      r += p;
      if (r >= q)
        {
          y++;
          r -= q;
        }
    }
}

void draw_vertical_line (int x, int y0, int y1, uint32_t colour)
{
  for (int y = y0; y <= y1; y++)
    draw_point (x, y, colour);
}

void draw_horizontal_line (int x0, int x1, int y, uint32_t colour)
{
  for (int x = x0; x <= x1; x++)
    draw_point (x, y, colour);
}

void draw (void)
{
  glClearColor (0.0, 0.0, 0.0, 0.0);
  glClear (GL_COLOR_BUFFER_BIT);
  gluBuild2DMipmaps (GL_TEXTURE_2D, 3, WIDTH, HEIGHT,
                     GL_RGBA, GL_UNSIGNED_BYTE, display_mem);
  glColor3f (1, 1, 1);
  glBegin (GL_QUADS);
  glTexCoord2f (0, 1);
  glVertex2f (0, 0);
  glTexCoord2f (1, 1);
  glVertex2f (WIDTH, 0);
  glTexCoord2f (1, 0);
  glVertex2f (WIDTH, HEIGHT);
  glTexCoord2f (0, 0);
  glVertex2f (0, HEIGHT);
  glEnd ();
  glFlush ();
  glutSwapBuffers ();
}

void timer (int value)
{
  for (int i = 0; i < 1000; i++)
    fill (BLACK, RED);
  glutPostRedisplay ();
  glutTimerFunc (1, timer, 0);
}

int main (int argc, char **argv)
{
  display_mem = malloc (WIDTH * HEIGHT * 4);

  glutInit (&argc, argv);
  glutInitWindowSize (WIDTH, HEIGHT);
  glutInitDisplayMode (GLUT_RGB | GLUT_DOUBLE);
  (void) glutCreateWindow ("Test");

  glViewport (0, 0, WIDTH, HEIGHT);
  glMatrixMode (GL_PROJECTION);
  glLoadIdentity ();
  glOrtho (0, WIDTH, 0, HEIGHT, -1, 1);
  glMatrixMode (GL_MODELVIEW);
  glLoadIdentity ();
  glClearColor (0, 0, 0, 0);
  glEnable (GL_TEXTURE_2D);

  glGenTextures (1, &texture);
  glBindTexture (GL_TEXTURE_2D, texture);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

  clear_display ();
  draw_line (0, 0, WIDTH - 1, HEIGHT - 1, WHITE);
  draw_horizontal_line (0, WIDTH - 1, 300, WHITE);
  draw_vertical_line (700, 0, HEIGHT - 1, WHITE);
  push_pair (550, 350);

  glutDisplayFunc (draw);
  glutTimerFunc (1, timer, 0);
  glutPostRedisplay ();
  glutMainLoop ();
}
