#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include <stdlib.h>

#define WIDTH 1024
#define HEIGHT 768

#define STEP 64

unsigned char *display_mem;
GLuint texture;

void clear_display (void)
{
  for (int i = 0; i < WIDTH * HEIGHT / 8; i++)
    display_mem[i] = 0;
}

void draw_point (int x, int y)
{
  int i = y * WIDTH * 4;
  i += x * 4;
  display_mem[i + 0] = 255;
  display_mem[i + 1] = 255;
  display_mem[i + 2] = 255;
}

int read_point (int x, int y)
{
  int i = y * WIDTH * 4;
  i += x * 4;
  if (display_mem[i] > 0)
    return 1;
  else
    return 0;
}

void fill (int x, int y)
{
  if (read_point (x, y) == 0)
    {
      draw_point (x, y);
      fill (x + 1, y);
      fill (x - 1, y);
      fill (x, y + 1);
      fill (x, y - 1);
    }
}

void draw_line (int x0, int y0, int x1, int y1)
{
  int p = y1 - y0;
  int q = x1 - x0;
  int r = q / 2;
  int y = y0;
  for (int x = x0; x <= x1; x++)
    {
      draw_point (x, y);
      r += p;
      if (r >= q)
        {
          y++;
          r -= q;
        }
    }
}

void draw_vertical_line (int x, int y0, int y1)
{
  for (int y = y0; y <= y1; y++)
    draw_point (x, y);
}

void draw_horizontal_line (int x0, int x1, int y)
{
  for (int x = x0; x <= x1; x++)
    draw_point (x, y);
}

void draw (void)
{
  glClearColor (0.0, 0.0, 0.0, 0.0);
  glClear (GL_COLOR_BUFFER_BIT);

  clear_display ();
  draw_line (0, 0, WIDTH - 1, HEIGHT - 1);
  draw_horizontal_line (0, WIDTH - 1, 300);
  draw_vertical_line (700, 0, HEIGHT - 1);
  fill (550, 350);

  gluBuild2DMipmaps (GL_TEXTURE_2D, 3, WIDTH, HEIGHT,
                     GL_RGBA, GL_UNSIGNED_BYTE, display_mem);
  glColor3f (1, 1, 1);
  glBegin (GL_QUADS);
  glTexCoord2f (0, 1);
  glVertex2f (0, 0);
  glTexCoord2f (1, 1);
  glVertex2f (WIDTH, 0);
  glTexCoord2f (1, 0);
  glVertex2f (WIDTH, HEIGHT);
  glTexCoord2f (0, 0);
  glVertex2f (0, HEIGHT);
  glEnd ();
  glFlush ();
  glutSwapBuffers ();
}

int main (int argc, char **argv)
{
  display_mem = malloc (WIDTH * HEIGHT * 4);

  glutInit (&argc, argv);
  glutInitWindowSize (WIDTH, HEIGHT);
  glutInitDisplayMode (GLUT_RGB | GLUT_DOUBLE);
  (void) glutCreateWindow ("Test");

  glViewport (0, 0, WIDTH, HEIGHT);
  glMatrixMode (GL_PROJECTION);
  glLoadIdentity ();
  glOrtho (0, WIDTH, 0, HEIGHT, -1, 1);
  glMatrixMode (GL_MODELVIEW);
  glLoadIdentity ();
  glClearColor (0, 0, 0, 0);
  glEnable (GL_TEXTURE_2D);

  glGenTextures (1, &texture);
  glBindTexture (GL_TEXTURE_2D, texture);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
/*
  gluBuild2DMipmaps (GL_TEXTURE_2D, 3, WIDTH, HEIGHT,
                     GL_RGBA, GL_UNSIGNED_BYTE, display_mem);
*/
  glutDisplayFunc (draw);
  glutPostRedisplay ();
  glutMainLoop ();
}
