#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include <stdlib.h>

#define WIDTH 1024
#define HEIGHT 768

#define STEP 64

unsigned char *display_mem;

void clear_display (void)
{
  for (int i = 0; i < WIDTH * HEIGHT / 8; i++)
    display_mem[i] = 0;
}

void draw_point (int x, int y)
{
  int i = y * WIDTH / 8;
  i += x / 8;
  display_mem[i] |= 0b10000000 >> x % 8;
}

int read_point (int x, int y)
{
  int i = y * WIDTH / 8;
  i += x / 8;
  if (display_mem[i] & 0b10000000 >> x % 8)
    return 1;
  else
    return 0;
}

void draw_line (int x0, int y0, int x1, int y1)
{
  int p = y1 - y0;
  int q = x1 - x0;
  int r = q / 2;
  int y = y0;
  for (int x = x0; x <= x1; x++)
    {
      draw_point (x, y);
      r += p;
      if (r >= q)
        {
          y++;
          r -= q;
        }
    }
}

void draw_vertical_line (int x, int y0, int y1)
{
  for (int y = y0; y <= y1; y++)
    draw_point (x, y);
}

void draw_horizontal_line (int x0, int x1, int y)
{
  for (int x = x0; x <= x1; x++)
    draw_point (x, y);
}

void draw (void)
{
  glClearColor (0.0, 0.0, 0.0, 0.0);
  glClear (GL_COLOR_BUFFER_BIT);
  clear_display ();
  draw_line (0, 0, WIDTH - 1, HEIGHT - 1);
  draw_horizontal_line (0, WIDTH - 1, 300);
  draw_vertical_line (700, 0, HEIGHT - 1);
  glBitmap (WIDTH, HEIGHT, 0.0, 0.0, 0.0, 0.0, display_mem);
  glFlush ();
  glutSwapBuffers ();
}

int main (int argc, char **argv)
{
  display_mem = malloc (WIDTH * HEIGHT / 8);
  glutInit (&argc, argv);
  glutInitDisplayMode (GLUT_RGB | GLUT_DOUBLE);
  glutInitWindowSize (WIDTH, HEIGHT);
  (void) glutCreateWindow ("Test");
  glutDisplayFunc (draw);
  glutMainLoop ();
  return 0;
}
