#include <stdlib.h>
#include <stdio.h>

#define FIFO_SIZE 42

typedef struct
{
  int x, y;
}
pair;

pair the_fifo[FIFO_SIZE];

int fifo_write = 0;
int fifo_read = 0;

void push_pair (int x, int y)
{
  printf ("pushing (%d,%d)\n", x, y);
  the_fifo[fifo_write].x = x;
  the_fifo[fifo_write].y = y;
  fifo_write++;
  if (fifo_write >= FIFO_SIZE)
    fifo_write = 0;
  if (fifo_write == fifo_read)
    {
      fprintf (stderr, "push_pair: fifo overflow\n");
      exit (1);
    }
}

void pop_pair (void)
{
  if (fifo_write != fifo_read)
    {
      printf ("popping (%d,%d)\n", the_fifo[fifo_read].x, the_fifo[fifo_read].y);
      fifo_read++;
      if (fifo_read >= FIFO_SIZE)
        fifo_read = 0;
    }
  else
    printf ("pop_pair: fifo is empty\n");
}

void dump_fifo (void)
{
  if (fifo_write == fifo_read)
    printf ("dump_fifo: fifo is empty\n");
  else
    {
      int i;
      printf ("dump_fifo:");
      i = fifo_read;
      while (i != fifo_write)
        {
          printf (" (%d,%d)", the_fifo[i].x, the_fifo[i].y);
          i++;
          if (i >= FIFO_SIZE)
            i = 0;
        }
      printf ("\n");
    }
}

int main (void)
{
  dump_fifo ();
  push_pair (3, 0);
  dump_fifo ();
  push_pair (7, 2);
  dump_fifo ();
  push_pair (23, 23);
  dump_fifo ();
  pop_pair ();
  dump_fifo ();
  pop_pair ();
  dump_fifo ();
  push_pair (42, 137);
  dump_fifo ();
  pop_pair ();
  dump_fifo ();
  pop_pair ();
  dump_fifo ();
  return 0;
}
