#include <stdio.h>
#include <stdlib.h>

typedef struct date
{
  char day, month;
  int year;
  void (*set)(struct date *this, char day, char month, int year);
  void (*output)(struct date *this);
} date;

void delete_date (date *this)  /* "Destruktor" */
{
  free (this);
}

void set_date (date *this, char day, char month, int year)
{
  this->day = day;
  this->month = month;
  this->year = year;
}

void output_date (date *this)
{
  printf ("%d.%d.%d\n", this->day, this->month, this->year);
}

date *new_date (void)  /* "Konstruktor" */
{
  date *this = malloc (sizeof (date));
  this->day = 1;
  this->month = 1;
  this->year = 1970;
  this->set = set_date;
  this->output = output_date;
  return this;
}

int main (void)
{
  date *today = new_date ();
  today->set (today, 24, 1, 2013);
  today->output (today);
  delete_date (today);
  return 0;
}
