#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>

void draw (void)
{
  glClear (GL_COLOR_BUFFER_BIT + GL_DEPTH_BUFFER_BIT);
  GLfloat color[] = { 0.0, 1.0, 0.0 };
  glMaterialfv (GL_FRONT, GL_AMBIENT, color);
  glMaterialfv (GL_FRONT, GL_DIFFUSE, color);
  glutSolidCube (0.5);
  glFlush ();
}

int main (int argc, char **argv)
{
  glutInit (&argc, argv);
  glutInitDisplayMode (GLUT_RGBA | GLUT_SINGLE | GLUT_DEPTH);
  glutInitWindowSize (1024, 768);
  glutCreateWindow ("Cube");
  glMatrixMode (GL_PROJECTION);
  glLoadIdentity ();
  gluPerspective (20.0, -1.33333, 3.0, 7.0);
  glMatrixMode (GL_MODELVIEW);
  glLoadIdentity ();
  glTranslatef (0.0, 0.0, -5.0);
  glClearColor (0.0, 0.0, 0.0, 0.0);
  glEnable (GL_DEPTH_TEST);
  glEnable (GL_LIGHTING);
  glEnable (GL_LIGHT0);
  static GLfloat light0_position[] = { 1.0, 0.0, 1.0, 0.0 };
  glLightfv (GL_LIGHT0, GL_POSITION, light0_position);
  glutDisplayFunc (draw);
  glutMainLoop ();
  return 0;
}
