#include <stdlib.h>

typedef enum
{
  found_nothing,
  found_wall,
  found_target
}
robosim_sensor_result;

extern void robosim_init (int argc, char **argv, char *png_filename,
                          int initial_x, int initial_y, int initial_direction);
extern void robosim_run (void);

extern void robosim_start_move (void);
extern void robosim_stop_move (void);
extern int robosim_moving (void);

extern int robosim_get_distance (void);
extern void robosim_reset_distance (void);

extern void robosim_rotate (int degrees);

extern robosim_sensor_result robosim_query_sensor (void);

extern void robosim_on_key_pressed (void (*handler) (char which_key));
extern void robosim_on_timer (void (*handler) (void));
