#include <stdlib.h>
#include <stdio.h>

#define STACK_SIZE 42

typedef struct
{
  int x, y;
}
pair;

pair the_stack[STACK_SIZE];

int stack_pointer = 0;

void push_pair (int x, int y)
{
  printf ("pushing (%d,%d)\n", x, y);
  if (stack_pointer < STACK_SIZE)
    {
      the_stack[stack_pointer].x = x;
      the_stack[stack_pointer].y = y;
      stack_pointer++;
    }
  else
    {
      fprintf (stderr, "push_pair: stack overflow\n");
      exit (1);
    }
}

void pop_pair (void)
{
  if (stack_pointer > 0)
    {
      stack_pointer--;
      printf ("popping (%d,%d)\n", the_stack[stack_pointer].x, the_stack[stack_pointer].y);
    }
  else
    printf ("pop_pair: stack is empty\n");
}

void dump_stack (void)
{
  if (stack_pointer <= 0)
    printf ("dump_stack: stack is empty\n");
  else
    {
      int i;
      printf ("dump_stack:");
      for (i = 0; i < stack_pointer; i++)
        printf (" (%d,%d)", the_stack[i].x, the_stack[i].y);
      printf ("\n");
    }
}

int main (void)
{
  dump_stack ();
  push_pair (3, 0);
  dump_stack ();
  push_pair (7, 2);
  dump_stack ();
  push_pair (23, 23);
  dump_stack ();
  pop_pair ();
  dump_stack ();
  pop_pair ();
  dump_stack ();
  push_pair (42, 137);
  dump_stack ();
  pop_pair ();
  dump_stack ();
  pop_pair ();
  dump_stack ();
  return 0;
}
