#include <stdlib.h>
#include <stdio.h>

#define STACK_SIZE 42

int the_stack[STACK_SIZE];

int stack_pointer = 0;

void push_number (int number)
{
  printf ("pushing %d\n", number);
  if (stack_pointer < STACK_SIZE)
    {
      the_stack[stack_pointer] = number;
      stack_pointer++;
    }
  else
    {
      fprintf (stderr, "push_number: stack overflow\n");
      exit (1);
    }
}

void pop_number (void)
{
  if (stack_pointer > 0)
    {
      stack_pointer--;
      printf ("popping %d\n", the_stack[stack_pointer]);
    }
  else
    printf ("pop_number: stack is empty\n");
}

void dump_stack (void)
{
  if (stack_pointer <= 0)
    printf ("dump_stack: stack is empty\n");
  else
    {
      int i;
      printf ("dump_stack:");
      for (i = 0; i < stack_pointer; i++)
        printf (" %d", the_stack[i]);
      printf ("\n");
    }
}

int main (void)
{
  dump_stack ();
  push_number (3);
  dump_stack ();
  push_number (7);
  dump_stack ();
  push_number (137);
  dump_stack ();
  pop_number ();
  dump_stack ();
  pop_number ();
  dump_stack ();
  push_number (42);
  dump_stack ();
  pop_number ();
  dump_stack ();
  pop_number ();
  dump_stack ();
  return 0;
}
