#include <stdlib.h>
#include "robosim.h"

#define SQUARE_SIZE 40

void key_handler (char which_key)
{
  switch (which_key)
    {
    case 'l':
      robosim_rotate (-90);
      break;
    case 'r':
      robosim_rotate (90);
      break;
    case ' ':
      if (robosim_moving ())
        robosim_stop_move ();
      else
        robosim_start_move ();
      break;
    case 'q':
      exit (0);
    }
}

void timer_handler (void)
{
  int distance = robosim_get_distance ();
  if (distance >= SQUARE_SIZE)
    {
      robosim_rotate (90);
      robosim_reset_distance ();
    }
}

int main (int argc, char **argv)
{
  robosim_init (argc, argv, "parcour.png", 426, 493, -90);
  robosim_on_key_pressed (key_handler);
  robosim_on_timer (timer_handler);
  robosim_run ();
  return 0;
}
