#include <stdlib.h>
#include "robosim.h"

#define PIXEL_SIZE 40
#define DIRECTION_FORWARD   1
#define DIRECTION_BACKWARD -1

int direction, distance_from_home;

void key_handler (char which_key)
{
  switch (which_key)
    {
    case 'l':
      if (!robosim_moving ())
        robosim_rotate (-90);
      break;
    case 'r':
      if (!robosim_moving ())
        robosim_rotate (90);
      break;
    case ' ':
      if (!robosim_moving ())
        {
          direction = DIRECTION_FORWARD;
          distance_from_home = 0;
          robosim_reset_distance ();
          robosim_start_move ();
        }
      break;
    case 'q':
      exit (0);
    }
}

void timer_handler (void)
{
  robosim_sensor_result sensor;
  int max_distance;
  
  sensor = robosim_query_sensor ();
  if (sensor == found_wall)
    {
      distance_from_home = robosim_get_distance ();
      robosim_reset_distance ();
      direction = DIRECTION_BACKWARD;
      robosim_rotate (180);
    }

  if (direction == DIRECTION_FORWARD)
    max_distance = PIXEL_SIZE;
  else
    max_distance = distance_from_home;
  if (robosim_get_distance () >= max_distance)
    robosim_stop_move ();
}

int main (int argc, char **argv)
{
  robosim_init (argc, argv, "parcour.png", 426, 493, -90);
  robosim_on_key_pressed (key_handler);
  robosim_on_timer (timer_handler);
  robosim_run ();
  return 0;
}
