#include <stdio.h>

#include "test.xbm"

void set_bit (int Index)
{
  test_bits[Index / 8] |= 1 << Index % 8;
}

void clear_bit (int Index)
{
  test_bits[Index / 8] &= ~(1 << Index % 8);
}

int get_bit (int Index)
{
  return (test_bits[Index / 8] & (1 << Index % 8)) != 0;
}

void set_bit_2 (int x, int y)
{
  set_bit (y * test_width + x);
}

void clear_bit_2 (int x, int y)
{
  clear_bit (y * test_width + x);
}

int get_bit_2 (int x, int y)
{
  return get_bit (y * test_width + x);
}

int main (void)
{
  int i, j;
  for (i = 0; i < test_height; i++)
    {
      for (j = 0; j < test_width; j++)
        if (get_bit_2 (j, i) != 0)
          printf ("*");
        else
          printf (".");
      printf ("\n");
    }
  return 0;
}
