#include <stdio.h>

#define BUF_SIZE 1000
#define BYTES_PER_LINE 10

#define IMG_WIDTH (8 * BYTES_PER_LINE)
#define IMG_HEIGHT (BUF_SIZE / BYTES_PER_LINE)

unsigned char Buffer[BUF_SIZE];

void set_bit (int Index)
{
  Buffer[Index / 8] |= (1 << 7) >> Index % 8;
}

void clear_bit (int Index)
{
  Buffer[Index / 8] &= ~((1 << 7) >> Index % 8);
}

int get_bit (int Index)
{
  return (Buffer[Index / 8] & ((1 << 7) >> Index % 8)) != 0;
}

void set_bit_2 (int x, int y)
{
  set_bit (y * IMG_WIDTH + x);
}

void clear_bit_2 (int x, int y)
{
  clear_bit (y * IMG_WIDTH + x);
}

int get_bit_2 (int x, int y)
{
  return get_bit (y * IMG_WIDTH + x);
}

int main (void)
{
  FILE *image;
  int i;
  image = fopen ("test.pbm", "w");
  fprintf (image, "P4\n%d %d\n", IMG_WIDTH, IMG_HEIGHT);
  for (i = 20; i < 60; i++)
    set_bit_2 (i, i);
  for (i = 0; i < BUF_SIZE; i++)
    fprintf (image, "%c", Buffer[i]);
  fclose (image);
  return 0;
}

/*

P4
80 100
^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^@^ ...

*/
